clear all
close all
clc

fHandle = @(x) f(x);
a = 1;
b = 9;
tol = 1e-2;

%Apply adaptive Simpson's rule
s = integralSimpsons(fHandle, a, b);
[Int, intervals] = adaptiveSimpsons(fHandle, a, b, tol, s);

%Plot the black box function
x = a:0.01:b;
plot(x, f(x))

%Display the intervals determined by the adaptive algorithm
yLim = get(gca, 'YLim');
hold on
for ii = 1:length(intervals)
    h = line([intervals(ii,1) intervals(ii,1)], [yLim(1) yLim(2)]);
    set(h,'LineStyle',':', 'Color', [0, 0, 0]);
end
hold off